﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Threading;

namespace PsgBase
{
    public partial class psgToolStripCustom : ToolStrip
    {
        psgDataGridView gridControl;
        string gridKeyValue;
        string gridKeyField;
        int hmn_loop;

        public psgToolStripCustom()
        {
            InitializeComponent();
        }

        public psgToolStripCustom(IContainer container)
        {
            container.Add(this);

            InitializeComponent();
        }

        [Browsable(false)]
        public psgDataGridView GridControl
        {
            get { return gridControl; }
            set { gridControl = value; }
        }

        [Category("PSG")]
        public string PsgGridKeyField
        {
            get { return gridKeyField; }
            set { gridKeyField = value; }
        }

        [Category("PSG")]
        public string PsgGridKeyValue
        {
            get { return gridKeyValue; }
            set { gridKeyValue = value; }
        }

        public void psgInsert(DataRow _row)
        {
            DataTable dt = _row.Table;
            this.psgInsert(ref dt, _row);
        }

        public void psgInsert(ref DataTable dt, DataRow _row)
        {
            dt.Rows.InsertAt(_row, 0);
            Base.psgIntf.SelectRowGrid(this.gridControl, 0);
            Base.psgIntf.psgInsert(_row, this.gridControl.PsgServerTableName, false);           

            ThreadStart startDelegate = new ThreadStart(CheckInsert);
            Thread thread = new Thread(startDelegate);
            thread.Priority = ThreadPriority.Lowest;
            thread.Start();
        }

        public void CheckInsert()
        {
            hmn_loop = 0;
            while (Intf.cmdResult != "OK" && this.hmn_loop <= 200)
            {
                Thread.Sleep(30);
                this.hmn_loop = this.hmn_loop + 1;
            }

            DataTable dtGrid = (DataTable)this.gridControl.DataSource;
            if (Intf.cmdResult != "OK")
            {
                MessageBox.Show("Check server connectivity and try again!", "Server communication failed", MessageBoxButtons.OK);               
                return;
            }

            //DataRow[] rows = dtGrid.Select(string.Format("{0}='{1}'", this.gridControl.PsgFieldKey, this.PsgGridKeyValue));
            //if (rows.Length > 0)
            //    dtGrid.Rows.Remove(rows[0]);
            //dtGrid.Rows.InsertAt(rows[0], 0);
            this.gridControl.Refresh();            
        }

        public void psgDelete()
        {
            if (Utils.ConfirmDelete())
            {
                //stergere din grid
                List<string> mc = new List<string>();
                string _id = string.Empty;
                foreach (DataGridViewRow row in this.gridControl.SelectedRows)
                {
                    _id = row.Cells[this.gridControl.GetFieldKey()].Value.ToString().Trim();
                    Base.psgIntf.DeleteRowGrid((DataTable)this.gridControl.DataSource, this.gridControl, this.gridControl.PsgFieldKey, this.gridControl.GetFieldKey(), _id);
                    mc.Add(Base.psgIntf.psgDelete(this.gridControl.PsgServerTableName, _id, this.gridControl.GetFieldKey(), true));
                }
                Base.psgIntf.psgMultiCommand(ref mc);

                //stergere din baza de date
                Base.psgIntf.psgDelete(this.gridControl.PsgServerTableName, this.PsgGridKeyValue, this.PsgGridKeyField,false);

                ThreadStart startDelegate = new ThreadStart(CheckDelete);
                Thread thread = new Thread(startDelegate);
                thread.Priority = ThreadPriority.Lowest;
                thread.Start();
            }
        }

        public void CheckDelete()
        {
            hmn_loop = 0;
            while (Intf.cmdResult != "OK" && this.hmn_loop <= 200)
            {
                Thread.Sleep(30);
                this.hmn_loop = this.hmn_loop + 1;
            }

            DataTable dtGrid = (DataTable)this.gridControl.DataSource;
            if (Intf.cmdResult != "OK")
            {
                MessageBox.Show("Check server connectivity and try again!", "Server communication failed", MessageBoxButtons.OK);             
                return;
            }

            //DataRow[] rows = dtGrid.Select(string.Format("{0}='{1}'", this.gridControl.PsgFieldKey, this.PsgGridKeyValue));
            //if (rows.Length > 0)            
            //    dtGrid.Rows.Remove(rows[0]);

            this.gridControl.Refresh();
        }
    }
}
